#!/bin/sh

NOW=$(date +"%m.%d.%Y")
USER=$(whoami)

## clean up ##
rm -rf $HOME/Desktop/Source/ppsspp/build-osx-fat &&
rm -rf $HOME/Desktop/PPSSPP-OSX/PPSSPPSDL.app/Contents/MacOS/PPSSPPSDL &&
rm -rf $HOME/Desktop/PPSSPP-OSX/PPSSPPSDL.app/Contents/MacOS/assets &&

## compile ppsspp ##
cd $HOME/Desktop/Source/ppsspp &&
git pull &&
git submodule update --init &&
git submodule update &&
# rm -rf /Volumes/Data/Jeremy/Desktop/Source/ppsspp/build-osx-fat &&
mkdir $HOME/Desktop/Source/ppsspp/build-osx-fat &&
cd $HOME/Desktop/Source/ppsspp/build-osx-fat &&
cmake $HOME/Desktop/Source/ppsspp &&
make -j8 &&

## package ppsspp ##
cp -a $HOME/Desktop/Source/ppsspp/build-osx-fat/assets $HOME/Desktop/PPSSPP-OSX/PPSSPPSDL.app/Contents/MacOS/ &&
cp -a $HOME/Desktop/Source/ppsspp/build-osx-fat/PPSSPPSDL $HOME/Desktop/PPSSPP-OSX/PPSSPPSDL.app/Contents/MacOS/ &&
cp -a $HOME/Desktop/PPSSPP-OSX /tmp &&
cd /tmp &&
hdiutil create -volname PPSSPP_OSX-$NOW -srcfolder /tmp/PPSSPP-OSX -ov -format UDZO PPSSPP_OSX-$NOW.dmg &&
cp -a /private/tmp/PPSSPP_OSX-$NOW.dmg $HOME/Google\ Drive/PPSSPP\ OS\ X/ &&
rm -rf /private/tmp/PPSSPP* 
